library (ggplot2)
library(tidyr)
library(datasets)
library(dplyr)
library(openxlsx)

##____ RYM-CAB_____ ##
# Residuo de Yerba Mate <- Tratamiento alcalino y Blanqueamiento 

MuestraA.$Etiqueta= all= "RYM-CAB_a"
MuestraB$Etiqueta= all= "RYM-CAB_b"
df1=rbind(MuestraA.,MuestraB)

ggplot(df1, mapping = aes(x = Temp, y= Pmasa, color=Etiqueta)) +
  geom_line()

write.xlsx(x=df1,file="TGA.RYM-CAB.xlsx",row.names=F)

a1=TGA_RYM_CAB[1:4101,2:6]
head(a1)
a2=TGA_RYM_CAB[4102:8202,2:6]
head(a2)
a3=cbind(a1,a2)

write.xlsx(x=a3,file="TGA.RYM_Promedio.xlsx",row.names=F)
###________
##---- RYM-CAB & AgNPs____##
# Residuo de Yerba Mate dopadas de nanopartículas de plata 

MuestraD$Etiqueta= all= "TI-CNP_d"
MuestraE$Etiqueta= all= "TI-CNP_e"
df2=rbind(MuestraD,MuestraE)

ggplot(TGA_TI_CNP, mapping = aes(x = Temp, y= Pmasa, color=Etiqueta)) +
  geom_line()

write.xlsx(x=df2,file="TGA.TI-CNP.xlsx",row.names=F)

b1=TGA_TI_CNP[1:4110,2:6]
b2=TGA_TI_CNP[4111:8220,2:6]
b3=cbind(b1,b2)
write.xlsx(x=b3,file="TGA.TICNP_Promedio.xlsx",row.names=F)

## Fibras de celulosa y fibras con AgNps

df3=rbind(TGA_TI_CNP, TGA_RYM_CAB)

ggplot(df3, mapping = aes(x = Temp, y= Pmasa, color=Etiqueta)) +
  geom_line()

a=df3[df3$Etiqueta == "RYM-CAB_b",]
b=df3[df3$Etiqueta == "TI-CNP_e",]
c=rbind(a,b)

### DATA FRAME CON PROMEDIO DE LOS DATOS DE MEDICIONES 
c=rbind(TGA_RYM_Promedio,TGA_TICNP_Promedio)

ggplot(c, mapping = aes(x = Temp, y= Pmasa, colour=Etiqueta)) +
  geom_line(size=1, alpha=0.8)+
  scale_y_continuous(limits = c(15, 100), breaks = seq(from = 0, to = 100, by = 25))+
  scale_x_continuous(limits = c(32, 600), breaks = seq(from = 0, to = 600, by = 100))+
  labs(x = "Temperatura, °C", y = "∆m, %" )+
  theme(axis.title.x.bottom = element_text(hjust = 0.55, vjust = -2.5, face = 'bold', size = 16, family = 'Times New Roman', colour = 'black'),
        axis.text.x =  element_text(size = 14, family = 'Times New Roman', vjust = 0.5, hjust = 0.5, colour = 'black'),
        axis.ticks.x = element_line(size = 0.5),
        axis.title.y.left = element_text(hjust = 0.5, vjust = 3.5, face = 'bold', size = 16, family = 'Times New Roman', colour = 'black'),
        axis.text.y = element_text(size = 14, family = 'Times New Roman', vjust = 0.5, hjust = 1, colour = 'black'),
        panel.background = element_blank(), 
        panel.grid = element_blank(),
        axis.line = element_line(colour = "black"),
        strip.background = element_blank(),
        strip.text = element_blank(), 
        plot.margin = margin(20,20,20,20),
        plot.background = element_rect(colour= "black"), 
        legend.position = c(0.3,0.2), 
        legend.title = element_blank(),
        legend.text = element_text(size=12, family = 'Times New Roman'),
        legend.key = element_blank())+
  scale_color_manual(name="",
                     breaks=c("RYM-CAB", "TI-CNP"),
                     labels=c("Celulosa (CeB)", "Celulosa + AgNPs (CNins)"),
                     values = c('darkblue', "purple2"))


### Copia para analizar puntos de inflexión 
ggplot(c, mapping = aes(x = Temp, y= Pmasa, colour=Etiqueta)) +
  geom_line()+
  scale_y_continuous(limits = c(15, 100), breaks = seq(from = 0, to = 100, by = 25))+
  scale_x_continuous(limits = c(340, 390), breaks = seq(from = 340, to = 390, by = 4))+
  labs(x = "Temperatura, (°C)", y = "∆m, (%)" )+
  theme(axis.title.x.bottom = element_text(hjust = 0.55, vjust = -1.0, face = 'bold', size = 14, family = 'Times New Roman', colour = 'black'),
        axis.text.x =  element_text(size = 12, family = 'Times New Roman', vjust = 0.5, hjust = 0.5, colour = 'black', face = 'bold'),
        axis.ticks.x = element_line(size = 0.5),
        axis.title.y.left = element_text(hjust = 0.6, vjust = 1.5, face = 'bold', size = 14, family = 'Times New Roman', colour = 'black'),
        axis.text.y = element_text(size = 12, family = 'Times New Roman', vjust = 0.5, hjust = 1, colour = 'black', face = 'bold'),
        panel.background = element_blank(), 
        panel.grid = element_blank(),
        axis.line = element_line(colour = "black"),
        strip.background = element_blank(),
        strip.text = element_blank(), 
        plot.margin = margin(10,10,10,10),
        plot.background = element_rect(colour= "black"), 
        legend.position = c(0.8,0.9), 
        legend.title = element_blank(),
        legend.key = element_blank())+
  scale_color_manual(name="",
                     breaks=c("RYM-CAB_b", "TI-CNP_e"),
                     labels=c("RYM-CAB", "TI-CNP"),
                     values = c('darkblue', "darkred"))
